/*
 * Decompiled with CFR 0.152.
 */
package emulator.unittest.hardware.nmos6502.commands;

import emulator.EmulatorException;
import emulator.hardware.HwByte;
import emulator.hardware.nmos6502.Cpu6502;
import emulator.hardware.nmos6502.Flags6502;
import emulator.hardware.nmos6502.commands.DEX;
import emulator.hardware.nmos6502.operands.NoOperand;
import org.junit.Assert;
import org.junit.Test;

public class DEXTest {
    @Test
    public void testDecPositive() throws EmulatorException {
        this.executeAndCheckDEX(63, 0);
    }

    @Test
    public void testDecNegative() throws EmulatorException {
        this.executeAndCheckDEX(0, 128);
    }

    @Test
    public void testDecZero() throws EmulatorException {
        this.executeAndCheckDEX(1, 2);
    }

    private void executeAndCheckDEX(int val, int expected_flags) throws EmulatorException {
        Cpu6502 cpu = new Cpu6502();
        cpu.setX(new HwByte((long)val));
        new DEX().execute(cpu, new NoOperand());
        Assert.assertEquals((Object)new HwByte((long)(val - 1)), (Object)cpu.getX());
        Assert.assertEquals((Object)new Flags6502((long)expected_flags), (Object)cpu.getFlags());
    }
}

